// DeviceList.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"

#include "b2c2_defs.h"

#include "DeviceList.h"


BEGIN_MESSAGE_MAP(CDeviceList, CDialog)
	ON_LBN_DBLCLK(IDC_DEVICE_LIST, &CDeviceList::OnLbnDblclkDeviceList)
END_MESSAGE_MAP()


// CDeviceList dialog

IMPLEMENT_DYNAMIC(CDeviceList, CDialog)
CDeviceList::CDeviceList(CWnd* pParent /*=NULL*/)
	: CDialog(CDeviceList::IDD, pParent)
	, m_pListOfAdapaters(NULL)
	, m_dwDeviceListCount(0)
	, m_nSelectedDevice(0)
{
	m_nSelectedDevice = 0;
	m_dwDeviceListCount = 0;
	m_pListOfAdapaters = NULL;
}

CDeviceList::~CDeviceList()
{
}

void CDeviceList::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BOOL CDeviceList::OnInitDialog()
{
	CListBox* pListBox;
	DWORD dwIndex;
	TCHAR tcDeviceName[256];

	CDialog::OnInitDialog();

	if (m_pListOfAdapaters != NULL)
	{
		//  Select Device list box
		pListBox = (CListBox*)GetDlgItem(IDC_DEVICE_LIST);
		for (dwIndex = 0; dwIndex < m_dwDeviceListCount; dwIndex++)
		{
			if (!(m_pListOfAdapaters[dwIndex].wInUse))
			{
				sprintf(tcDeviceName, "%S - %S (r%S) - [%02x:%02x:%02x:%02x:%02x:%02x]",
					m_pListOfAdapaters[dwIndex].wsProductName,
					m_pListOfAdapaters[dwIndex].wsProductDescription,
					m_pListOfAdapaters[dwIndex].wsProductRevision,
					m_pListOfAdapaters[dwIndex].ucMACAddress[0],
					m_pListOfAdapaters[dwIndex].ucMACAddress[1],
					m_pListOfAdapaters[dwIndex].ucMACAddress[2],
					m_pListOfAdapaters[dwIndex].ucMACAddress[3],
					m_pListOfAdapaters[dwIndex].ucMACAddress[4],
					m_pListOfAdapaters[dwIndex].ucMACAddress[5]);

				int nIndex = pListBox->AddString( &tcDeviceName[0] );

				if (nIndex >= 0)
				{
					pListBox->SetItemData(nIndex, m_pListOfAdapaters[dwIndex].dwDeviceID );
				}
			}
		}

		pListBox->SetCurSel(0);

		// Initialize the ID field in case the dialog is not called.
		m_dwSelectedID = m_pListOfAdapaters[0].dwDeviceID;
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}


// CDeviceList message handlers

void CDeviceList::SetDeviceListAddress(tDEVICE_INFORMATION *pListOfAdapaters)
{
	m_pListOfAdapaters = pListOfAdapaters;

	// Initialize the ID field in case the dialog is not called.
	m_dwSelectedID = m_pListOfAdapaters[0].dwDeviceID;
}

void CDeviceList::SetDeviceListCount(DWORD dwDeviceListCount)
{
	m_dwDeviceListCount = dwDeviceListCount;
}

// Get the number of unused devices.
// A device is considered unused if it is not open for a TS stream.
int CDeviceList::GetAvailableDeviceCount()
{
	DWORD dwIndex;
	int nCount = 0;

	// if the device list has been set,
	// scan it for available (unused) devices
	if (m_pListOfAdapaters != NULL)
	{
		for (dwIndex = 0; dwIndex < m_dwDeviceListCount; dwIndex++)
		{
			if (!(m_pListOfAdapaters[dwIndex].wInUse))
			{
				nCount++;

				if (nCount == 1)
				{
					// In case there is only one device,
					// pre-select the device ID
					m_dwSelectedID = m_pListOfAdapaters[dwIndex].dwDeviceID;
				}
			}
		}
	}
	return nCount;
}

DWORD CDeviceList::GetSelectedDevice(void)
{
	return m_dwSelectedID;
}

void CDeviceList::OnOK()
{
	CListBox* pListBox;

	//  Select Device list box.
	pListBox = (CListBox*)GetDlgItem(IDC_DEVICE_LIST);

	m_nSelectedDevice = pListBox->GetCurSel();
	m_dwSelectedID = pListBox->GetItemData(m_nSelectedDevice);

	CDialog::OnOK();
}

// Treat double click as OK.
void CDeviceList::OnLbnDblclkDeviceList()
{
	// Double click = OK
	OnOK();
}
